/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.ClientBossEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ClientEventHandler {
    private static Map<Entity, ClientBossUI> bossInfoMap = new HashMap<Entity, ClientBossUI>();

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        bossInfoMap.clear();
        Minecraft.getInstance().gui.getBossOverlay().reset();
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide() || event.getEntity().level().getGameTime() % 5L != 0L) {
            return;
        }
        Entity target = Minecraft.getInstance().hitResult != null && Minecraft.getInstance().hitResult instanceof EntityHitResult ? ((EntityHitResult)Minecraft.getInstance().hitResult).getEntity() : null;
        ClientEventHandler.checkEntity(target);
        Iterator<Map.Entry<Entity, ClientBossUI>> iterator = bossInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, ClientBossUI> entry = iterator.next();
            entry.getValue().bossInfo.update((LivingEntity)entry.getKey(), entry.getValue().cap);
            if (!entry.getKey().isAlive() || entry.getValue().timeOut < entry.getKey().level().getGameTime()) {
                Minecraft.getInstance().gui.getBossOverlay().events.remove(entry.getValue().bossInfo.getId());
                iterator.remove();
                continue;
            }
            if (!event.getEntity().hasLineOfSight(entry.getKey())) continue;
            entry.getValue().timeOut = event.getEntity().level().getGameTime() + 600L;
        }
    }

    private static ClientBossUI createBossGUI(LivingEntity target, BossCapability cap) {
        ClientBossUI ui = new ClientBossUI(new ClientBossEvent(target, cap), (Entity)target, cap);
        Minecraft.getInstance().gui.getBossOverlay().events.put(ui.bossInfo.getId(), ui.bossInfo);
        return ui;
    }

    public static void checkEntity(Entity target) {
        BossCapability cap;
        if (target instanceof BossCapEntity && (cap = ((BossCapEntity)target).getBossCap()) != null && cap.isBoss() && cap.getBossType().showBossBar()) {
            if (bossInfoMap.containsKey(target)) {
                ClientBossUI ui = bossInfoMap.get(target);
                ui.timeOut = target.level().getGameTime() + 600L;
            } else {
                bossInfoMap.put(target, ClientEventHandler.createBossGUI((LivingEntity)target, cap));
            }
        }
    }

    private static class ClientBossUI {
        private ClientBossEvent bossInfo;
        private long timeOut;
        private Entity boss;
        private BossCapability cap;

        private ClientBossUI(ClientBossEvent bossEVent, Entity boss, BossCapability cap) {
            this.bossInfo = bossEVent;
            this.timeOut = boss.level().getGameTime() + 600L;
            this.boss = boss;
            this.cap = cap;
        }
    }
}

