/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.CustomEntityRenderData;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class BossCapMixin
extends LivingEntity
implements BossCapEntity {
    @Shadow
    private boolean persistenceRequired;
    @Unique
    private BossCapability bossCap = null;

    @Shadow
    public abstract void readAdditionalSaveData(CompoundTag var1);

    protected BossCapMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void brutalbosses$addSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.bossCap != null) {
            compoundTag.put(BossCapability.ID.toString(), (Tag)this.bossCap.serializeNBT());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void brutalbosses$readSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.contains(BossCapability.ID.toString())) {
            this.bossCap = new BossCapability((Entity)this);
            this.bossCap.deserializeNBT((Tag)compoundTag.getCompound(BossCapability.ID.toString()));
        }
    }

    @Override
    public void setBossCap(BossCapability cap) {
        this.bossCap = cap;
    }

    @Override
    public BossCapability getBossCap() {
        return this.bossCap;
    }

    @Inject(method={"convertTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void brutalbosses$onconvert(EntityType entityType, boolean bl, CallbackInfoReturnable cir) {
        if (this.bossCap != null && this.bossCap.isBoss()) {
            cir.setReturnValue(null);
        }
    }

    public float getPickRadius() {
        if (this instanceof CustomEntityRenderData) {
            return (float)((double)Math.max(0.0f, ((CustomEntityRenderData)((Object)this)).getVisualScale() - 1.0f) * this.getBoundingBox().getSize());
        }
        return 0.0f;
    }

    @Override
    public void setPersistence(boolean persistence) {
        this.persistenceRequired = persistence;
    }
}

