/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.world.RegionAwareTE;
import java.lang.ref.WeakReference;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RandomizableContainerBlockEntity.class})
public class LockableLootTileEntityMixin
implements RegionAwareTE {
    private boolean spawnedBoss = false;
    private WeakReference<ServerLevelAccessor> region = new WeakReference<Object>(null);

    @Inject(method={"setLootTable"}, at={@At(value="RETURN")})
    private void onSetLoot(ResourceKey<LootTable> resourceKey, CallbackInfo ci) {
        ServerLevelAccessor world = (ServerLevelAccessor)this.region.get();
        if (world != null && !this.spawnedBoss) {
            this.spawnedBoss = true;
            BossSpawnHandler.onChestPlaced(world, (RandomizableContainerBlockEntity)this);
        }
        this.region.clear();
    }

    @Inject(method={"applyImplicitComponents"}, at={@At(value="RETURN")})
    private void onLoadLoot(BlockEntity.DataComponentInput dataComponentInput, CallbackInfo ci) {
        ServerLevelAccessor world = (ServerLevelAccessor)this.region.get();
        if (world != null && !this.spawnedBoss) {
            this.spawnedBoss = true;
            BossSpawnHandler.onChestPlaced(world, (RandomizableContainerBlockEntity)this);
        }
        this.region.clear();
    }

    @Override
    public void setRegion(ServerLevelAccessor region) {
        this.region = new WeakReference<ServerLevelAccessor>(region);
    }
}

