/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MeleeAttackGoal.class})
public class MeleeAttackGoalMixin {
    @Shadow
    private int ticksUntilNextAttack;
    @Shadow
    @Final
    protected PathfinderMob mob;
    private float attackSpeedMod = 1.0f;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void load(PathfinderMob mob, double p_i1636_2_, boolean p_i1636_4_, CallbackInfo ci) {
        BossCapability cap = ((BossCapEntity)mob).getBossCap();
        if (cap != null && cap.isBoss()) {
            this.attackSpeedMod = cap.getBossType().getCustomAttributeValueOrDefault("attack_speed", 1.0f);
        }
    }

    @Inject(method={"checkAndPerformAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;resetAttackCooldown()V", shift=At.Shift.AFTER)})
    private void resetAttackCooldown(LivingEntity livingEntity, CallbackInfo ci) {
        this.ticksUntilNextAttack = (int)(20.0f / this.attackSpeedMod);
    }
}

