/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.IMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class BossCapMessage
implements IMessage,
CustomPacketPayload {
    public static final CustomPacketPayload.Type<BossCapMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"bosscap"));
    BossCapability cap = null;
    private int entityID = -1;
    private CompoundTag nbt = null;

    public BossCapMessage(BossCapability cap) {
        this.cap = cap;
    }

    public BossCapMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cap.getEntity().getId());
        buffer.writeNbt((Tag)this.cap.serializeNBT());
    }

    @Override
    public BossCapMessage read(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.nbt = buffer.readNbt();
        return this;
    }

    @Override
    public void handle(Player player) {
        Entity entity = player.level().getEntity(this.entityID);
        if (entity instanceof BossCapEntity) {
            ((BossCapEntity)entity).setBossCap(new BossCapability(entity));
            ((BossCapEntity)entity).getBossCap().deserializeNBT((Tag)this.nbt);
        }
    }

    @Override
    public ResourceLocation getID() {
        return TYPE.id();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

