/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.event.ClientEventHandler;
import com.brutalbosses.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class BossOverlayMessage
implements IMessage,
CustomPacketPayload {
    public static final CustomPacketPayload.Type<BossOverlayMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"bossoverlay"));
    private int entityID = -1;

    public BossOverlayMessage(int entityID) {
        this.entityID = entityID;
    }

    public BossOverlayMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
    }

    @Override
    public BossOverlayMessage read(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        return this;
    }

    @Override
    public void handle(Player player) {
        Entity entity = player.level().getEntity(this.entityID);
        if (entity != null) {
            ClientEventHandler.checkEntity(entity);
        }
    }

    @Override
    public ResourceLocation getID() {
        return TYPE.id();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

