/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.network.IMessage;
import java.util.Random;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VanillaParticleMessage
implements IMessage,
CustomPacketPayload {
    public static final CustomPacketPayload.Type<VanillaParticleMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"particlemsg"));
    private static final float WIDTH = 0.8f;
    private static final float CITIZEN_HEIGHT = 2.0f;
    private double x;
    private double y;
    private double z;
    private SimpleParticleType type;

    public VanillaParticleMessage() {
    }

    public VanillaParticleMessage(double x, double y, double z, SimpleParticleType type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    private void spawnParticles(SimpleParticleType particleType, Level world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.BONE)), x + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, y + 1.0 + (double)(rand.nextFloat() * 2.0f), z + (double)(rand.nextFloat() * 0.8f * 2.0f) - (double)0.8f, d0, d1, d2);
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeResourceLocation(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.type));
    }

    @Override
    public VanillaParticleMessage read(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.type = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(buffer.readResourceLocation());
        return this;
    }

    @Override
    public void handle(Player player) {
        this.spawnParticles(this.type, player.level, this.x, this.y, this.z);
    }

    @Override
    public ResourceLocation getID() {
        return TYPE.id();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

