/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.comforts.common.block.BaseComfortsBlock;
import com.illusivesoulworks.comforts.common.block.HammockBlock;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeAndNailBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty SUPPORTING = BooleanProperty.create((String)"supporting");
    private static final Map<Direction, VoxelShape> SHAPES_R = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0), (Object)Direction.WEST, (Object)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0)));
    private static final Map<Direction, VoxelShape> SHAPES_S = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)6.0, (double)3.0, (double)9.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)8.0, (double)7.0), (Object)Direction.WEST, (Object)Block.box((double)9.0, (double)3.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)6.0, (double)7.0, (double)8.0, (double)10.0)));

    public RopeAndNailBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOL).sound(SoundType.METAL).strength(0.2f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.getValue((Property)SUPPORTING) != false ? SHAPES_S.get(state.getValue((Property)HORIZONTAL_FACING)) : SHAPES_R.get(state.getValue((Property)HORIZONTAL_FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        boolean valid = blockstate.isFaceSturdy((BlockGetter)level, blockpos, direction);
        if (!valid && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RopeAndNailBlock.dropHammock((Level)serverLevel, pos, state);
        }
        return valid;
    }

    private static void dropHammock(Level level, BlockPos pos, BlockState state) {
        BlockPos frontPos = pos.relative((Direction)state.getValue((Property)HORIZONTAL_FACING));
        BlockState frontState = level.getBlockState(frontPos);
        if (((Boolean)state.getValue((Property)SUPPORTING)).booleanValue() && frontState.getBlock() instanceof HammockBlock) {
            BedPart bedpart = (BedPart)frontState.getValue((Property)BedBlock.PART);
            boolean isHead = bedpart == BedPart.HEAD;
            Direction frontDirection = (Direction)frontState.getValue((Property)HORIZONTAL_FACING);
            BlockPos otherPos = frontPos.relative(HammockBlock.getDirectionToOther(bedpart, frontDirection));
            if (isHead) {
                RopeAndNailBlock.dropResources((BlockState)frontState, (Level)level, (BlockPos)frontPos);
            }
            if (((Boolean)frontState.getValue((Property)BaseComfortsBlock.WATERLOGGED)).booleanValue()) {
                level.setBlock(frontPos, Blocks.WATER.defaultBlockState(), 35);
            } else {
                level.setBlock(frontPos, Blocks.AIR.defaultBlockState(), 35);
            }
            HammockBlock.dropRopeSupport(otherPos, frontDirection, !isHead, level);
        }
    }

    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        RopeAndNailBlock.dropHammock(level, pos, state);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] directions;
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockstate = this.defaultBlockState();
        Level worldreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : directions = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)((BlockState)blockstate.setValue((Property)HORIZONTAL_FACING, (Comparable)(direction1 = direction.getOpposite()))).setValue((Property)BaseComfortsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER))).canSurvive((LevelReader)worldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)BaseComfortsBlock.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return facing.getOpposite() == stateIn.getValue((Property)HORIZONTAL_FACING) && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    @Nonnull
    public BlockState rotate(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    @Nonnull
    public BlockState mirror(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SUPPORTING, HORIZONTAL_FACING, BaseComfortsBlock.WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BaseComfortsBlock.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

